#!/usr/bin/perl
# $Id: send.pm,v 1.8 2012/04/01 06:52:10 yason Exp $
package send;
use fetch;
use db;
use log;
use fileops;
use warnings;

# spool path constants (without leading slash)
our $SPOOL_ZAYAVKI        = "/mnt/archive/archive/wp/zayavki";
our $SPOOL_PROBAS         = "/mnt/archive/archive/wp/proba";
our $SPOOL_TT             = "/mnt/archive/archive/wp/tt";
our $SPOOL_ZJPEG           = "/mnt/archive/archive/wp/zjpeg";
our $SPOOL_PJPEG           = "/mnt/archive/archive/wp/pjpeg";
our $SPOOL_TMPDIR         = "/mnt/archive/archive/temp";

# temp variables for map table lookup
our $ret;
our $tmpd;
our $tmpf;

sub zayavki()
{
    my @dbids;
    my @localpaths;
    my @remotepaths;
    my $dbids_ref;
    my $localpaths_ref;
    my $i = 0;
    my $okay = 0;
    my $curfile;
    
    my $size_orig;
    my $size_arc;
    
    my $spool;
    my $delete;
    
    ($dbids_ref, $localpaths_ref) = fetch::zayavki_list();

    @dbids = @$dbids_ref;
    @localpaths = @$localpaths_ref;
    log::main("Fetched " . scalar(@localpaths) . " zayavki from database");
    log::zayavki("<<  Starting transfer process  >>");
    
    @remotepaths = @localpaths;	 # clone
    

    while($localpaths[$i])
    {
	# check if there is a void element
	# ???
	next if(!$localpaths[$i]);
	
	#
	#
        # fill $spool with right spool directory
	if( db::get_tx_count($dbids[$i]) > 0 )
	{
	    # retransmission
	    # set $spool to temporary directory to make backup collector happy :)
	    # in this case also let $delete = 1 (removing garbage after copy, as in old times)
	    
	    # considering okay to not to check /usr/backup for availability
	    $spool = $SPOOL_TMPDIR;
	    $delete = 1; 
	}
	else
	{
	    # this is the first time copy
	    # set $spool to backup spool directory
	    # and not to delete archive
	
	    $spool = $SPOOL_ZAYAVKI;
	    $delete = 0;
        }

	# lookup in table first
	chomp( $tmpf = `basename $remotepaths[$i]` );
	chomp( $_ = `dirname $remotepaths[$i]` );
	$tmpd = hash::lookup($_);
	print "\$remotepaths[\$i] is $remotepaths[$i]  \$_ is $_  \$tmpd is $tmpd\n";
	if ( $tmpd ne '' )
	{
	    $remotepaths[$i] =  $tmpd. "/". $tmpf;
	}
	else
	{	
	    # hardcoded
	    $remotepaths[$i] =~ s/\/mnt\/maket/\/mnt\/rmt_maket/;
	}
	
#	if(-e $remotepaths[$i] || -e $remotepaths[$i] . '.rar')
#	{
#	    log::error("Remote file $remotepaths[$i] or $remotepaths[$i].rar already exists");
#	    db::change_status($dbids[$i], 1);
#	}
#	else
#	{
	    # In this place we must be sure that local file is ok
	    if( -e $localpaths[$i] )
	    {
		# set $size_orig
		$size_orig = -s "$localpaths[$i]";
		
    		# rar and copy local file
		fileops::checkdir($remotepaths[$i]);
	         chomp($curfile = `basename $localpaths[$i]`) , $curfile .= '.rar';
		 
		 # two functions in log.pm makes newer versions of zlist happy
		 log::file_work_on($curfile, "rar");
		 
		 log::zayavki("compressing '$localpaths[$i]' -> '$spool/$curfile'");
		 
		 `/usr/bin/rar a -rr10% -ep '$spool/$curfile' '$localpaths[$i]'`;
		 if( ($? >> 8) == 0)
		 {
		    # rar exited successfully
		    	# set $size_arc
			$size_arc = -s "$spool/$curfile";
			
		    # it can be possible that file already uploaded by hand while rar copressed one
		    # so we should check for existence of archive in remote before send it
		    if( -e $remotepaths[$i] || -e $remotepaths[$i] . '.rar')
		    {
			log::error("Can not save $remotepaths[$i].rar cause of file has appeared after compressing");
			log::zayavki("Can not save $remotepaths[$i].rar cause of file has appeared after compressing");
			# file was uploaded by hand, let us change its status in db
			db::change_status($dbids[$i], 1);
			
#			log::file_work_done();
		    }
		    else
		    {
			# copy archive and then delete it from /usr/backup/spool
			log::zayavki("transferring $spool/$curfile -> $remotepaths[$i].rar");
			
			log::file_work_on($curfile, "copy");
			
			if( system("cp '$spool/$curfile' $remotepaths[$i].rar") == 0 )
			{
			    # OKAY
			    
			    log::zayavki("saved $localpaths[$i] -> $remotepaths[$i].rar [size_orig=$size_orig, size_arc=$size_arc]");
			    
			    log::file_work_done();
			    
			    log::diff($localpaths[$i], $size_orig, $size_arc);
			    # update database
			    db::change_status($dbids[$i], 1);
			    db::write_size_orig($dbids[$i], $size_orig);
			    db::write_size_arc($dbids[$i], $size_arc);
			    
			    # write ux_rpaths
			    db::write_ux_rpath($dbids[$i], "$remotepaths[$i].rar");
			    
			    # increment tx_count
			    db::increment_tx_count($dbids[$i]);
			    
			    $okay++;
			}
			else
			{
			    # error in the copy process
			    log::zayavki("error in copy process (see error log)");
			    log::error("error in copy process: $?");
			    
			    # additional cleanup for log::file_work_on()
#			    log::file_work_done();
			    
			}
	   		
			# finally, delete $spool/XXXXX.rar if $delete
			if($delete)
			{
			    if( (system("/bin/rm -f '$spool/$curfile'")) == 0 )
			    {
				log::zayavki("removed temporary file $spool/$curfile");
			    }
			    else
			    {
				# /bin/rm exits with error
				log::zayavki("error while removing temporary file $spool/$curfile (see error log)");
				log::error("error while removing temporary file $spool/$curfile: $?");
			    }
			}
		    }
		
		 }
		 else
		 {
		    # an error occurs in the archivation process
		    log::zayavki("error in archivation process (see error log)");
		    log::error("error in archivation process: $?");
		    
		    # clean out compressed file in /usr/backup/spool on error
		    #system("/bin/rm -f '/usr/backup/spool/$curfile'");
		    `/bin/rm -f '$spool/$curfile'`;
		    
		 }
	    }
	    else
	    {
		# error, local file doesn't exists
		log::error("Can not open local file $localpaths[$i]");
		log::zayavki("Can not open local file $localpaths[$i]");

	    }
#	}
	
	# next iteration of 'while' and increment of $i
	$i++;
	
	log::file_work_done();
    }
# end while
    
    log::main("Saved $okay zayavki on remote host");
    log::zayavki("<<  End transfer process  >>");
}



sub probas()
{
    my @dbids;
    my @localpaths;
    my @remotepaths;
    my $dbids_ref;
    my $localpaths_ref;
    my $i = 0;
    my $okay = 0;
    my $curfile;
    
    my $size_orig;
    my $size_arc;

    my $spool;
    my $delete;
    
    ($dbids_ref, $localpaths_ref) = fetch::probas_list();

    @dbids = @$dbids_ref;
    @localpaths = @$localpaths_ref;
    log::main("Fetched " . scalar(@localpaths) . " probas from database");
    log::probas("<<  Starting transfer process  >>");
    
    @remotepaths = @localpaths;	 # clone

    while($localpaths[$i])
    {
	# cloned from send::zayavki()
	 
	# check if there is a void element
	# ???
	next if(!$localpaths[$i]);
	
	#
	#
        # fill $spool with right spool directory
	if( db::get_tx_count($dbids[$i]) > 0 )
	{
	    # retransmission
	    # set $spool to temporary directory to make backup collector happy :)
	    # in this case also let $delete = 1 (removing garbage after copy, as in old times)
	    
	    # considering okay to not to check /usr/backup for availability
	    $spool = $SPOOL_TMPDIR;
	    $delete = 1;
	}
	else
	{
	    # this is the first time copy
	    # set $spool to backup spool directory
	    # and not to delete archive
	
	    $spool = $SPOOL_PROBAS;
	    $delete = 0;
        }

	# lookup in table first
	chomp( $tmpf = `basename $remotepaths[$i]` );
	chomp( $_ = `dirname $remotepaths[$i]` );
	$tmpd = hash::lookup($_);
	if ( $tmpd ne '' )
	{
	    $remotepaths[$i] =  $tmpd. "/". $tmpf;
	}
	else
	{	
	    # /mnt/maket/proba/* goes on /mnt/rmt_maket/proba/
#	    substr($remotepaths[$i], 1, 2, 'mnt/rmt_maket');
	$remotepaths[$i] =~ s/\/mnt\/maket/\/mnt\/rmt_maket/;
	}
	
	if(-e $remotepaths[$i] || -e $remotepaths[$i] . '.rar')
	{
	    log::error("Remote file $remotepaths[$i] already exists");
	    db::change_status($dbids[$i], 1);
	}
	else
	{
	    if( -e $localpaths[$i] )
	    {
		# rar and copy local file
		fileops::checkdir($remotepaths[$i]);
		
		# set $size_orig
		$size_orig = -s "$localpaths[$i]";
		
	         chomp($curfile = `basename $localpaths[$i]`) , $curfile .= '.rar';
		 
		 # two functions in log.pm makes newer versions of zlist happy
		 log::file_work_on($curfile, "rar");

		 log::probas("compressing '$localpaths[$i]' -> '$spool/$curfile'");

		`/usr/bin/rar a -rr10% -ep '$spool/$curfile' '$localpaths[$i]'`;
		 if( ($? >> 8) == 0)
		 {
		    # rar exited successfully
		    	# set $size_arc
			$size_arc = -s "$spool/$curfile";
		    
		    # it can be possible that file already uploaded by hand while rar copressed one
		    # so we should check for existence of archive in remote before send it
		    if( -e $remotepaths[$i] || -e $remotepaths[$i] . '.rar')
		    {
			log::error("Can not save $remotepaths[$i].rar cause of file has appeared after compressing");
			log::probas("Can not save $remotepaths[$i].rar cause of file has appeared after compressing");
			
			db::change_status($dbids[$i], 1);
		    }
		    else
		    {
			# copy archive and then delete it from $spool
			log::file_work_on($curfile, "copy");
			
			log::probas("transferring $spool/$curfile -> $remotepaths[$i].rar");
			
			if( system("cp '$spool/$curfile' $remotepaths[$i].rar") == 0 )
			{
			    log::probas("saved $localpaths[$i] -> $remotepaths[$i].rar [size_orig=$size_orig, size_arc=$size_arc]");
			    log::diff($localpaths[$i], $size_orig, $size_arc);
			    # update database
			    db::change_status($dbids[$i], 1);
			    db::write_size_orig($dbids[$i], $size_orig);
			    db::write_size_arc($dbids[$i], $size_arc);
			    
			    db::write_ux_rpath($dbids[$i], "$remotepaths[$i].rar");

			    # increment tx_count
			    db::increment_tx_count($dbids[$i]);
			    
			    $okay++;
			}
			else
			{
			    # error in the copy process
			    log::probas("error in copy process (see error log)");
			    log::error("error in copy process: $?");
			}
			
			if ($delete)
			{
			    # finally, delete $spool/XXXXX.rar
			    if( (system("/bin/rm -f '$spool/$curfile'")) == 0 )
			    {
				log::probas("removed temporary file $spool/$curfile");
			    }
			    else
			    {
				# /bin/rm exits with error
				log::probas("error while removing temporary file $spool/$curfile (see error log)");
				log::error("error while removing temporary file $spool/$curfile: $?");
			    }
			} # !$delete
		    }
		
		 }
		 else
		 {
		    # an error occurs in the archivation process
		    log::probas("error in archivation process (see error log)");
		    log::error("error in archivation process: $?");
		    
		    system("/bin/rm -f '$spool/$curfile'");
		 }		
	    }
	    else
	    {
		# error, local file doesn't exists
		log::error("Can not open local file $localpaths[$i]");
		log::probas("Can not open local file $localpaths[$i]");
	    }
	}
	
	# next iteration of 'while' and increment of $i
	$i++;
	
	log::file_work_done();
    }
    
    log::main("Saved $okay probas on remote host");
    log::probas("<<  End transfer process  >>");
}

sub tt()   
 {   
     my @dbids;   
     my @localpaths;   
     my @remotepaths;   
     my $dbids_ref;   
     my $localpaths_ref;   
     my $i = 0;   
     my $okay = 0;   
    
     my $size_orig;   
    
     ($dbids_ref, $localpaths_ref) = fetch::tt_list();   
    
     @dbids = @$dbids_ref;   
     @localpaths = @$localpaths_ref;   
     log::main("Fetched " . scalar(@localpaths) . " tt from database");   
     log::tt("<<  Starting transfer process  >>");   
    
     @remotepaths = @localpaths;  # clone   
    
     while($localpaths[$i])   
     {   
         # lookup in table first   
         chomp( $tmpf = `basename $remotepaths[$i]` );   
         chomp( $_ = `dirname $remotepaths[$i]` );   
         $tmpd = hash::lookup($_);   
         if ( $tmpd ne '' )   
         {   
             $remotepaths[$i] =  $tmpd. "/". $tmpf;   
         }   
         else   
         {   
             # hardcoded   
             $remotepaths[$i] =~ s/\/mnt\/maket/\/mnt\/rmt_maket/;
         }   
    
         if(-e $remotepaths[$i])   
         {   
             log::error("Remote file $remotefile[$i] already exists");   
             db::change_status($dbids[$i], 1);   
         }   
         else   
         {   
             if( -e $localpaths[$i] )   
             {   
                 fileops::checkdir($remotepaths[$i]);   
                 # set $size_orig   
                 $size_orig = -s "$localpaths[$i]";   
    
                 log::tt("transferring $localpaths[$i] -> $remotepaths[$i]");   
                 if( system("cp '$localpaths[$i]' '$remotepaths[$i]'") == 0 )   
                 {   
                         log::tt("saved $localpaths[$i] -> $remotepaths[$i] [size_orig=$size_orig]");   
                         # update database   
                         db::change_status($dbids[$i], 1);   
                         db::write_size_orig($dbids[$i], $size_orig);   
    
                 #   
                 #       WE SHOULD NOT FILL ux_rpath FIELD FOR tpp-types   
                 #   
                 #       XXX Please explain me why?   
                 #   
                 #       db::write_ux_rpath($dbids[$i], "$remotepaths[$i]");   
    
                         $okay++;   
    
                 }   
                 else   
                 {   
                     # error in the copy process   
                     log::tt("error in copy process (see error log)");   
                     log::error("error in copy process: $?");   
                 }   
             }   
             else   
             {   
                 # error, local file doesn't exists   
                 log::error("Can not open local file $localpaths[$i]");   
                 log::tt("Can not open local file $localpaths[$i]");   
             }   
         }   
    
         # next iteration of 'while' and increment of $i   
         $i++;   
     }   
    
     log::main("Saved $okay tt on remote host");   
     log::tt("<<  End transfer process  >>");   
 } 


sub zjpeg()
 {
     my @dbids;
     my @localpaths;
     my @remotepaths;
     my $dbids_ref;
     my $localpaths_ref;
     my $i = 0;
     my $okay = 0;

     my $size_orig;

     ($dbids_ref, $localpaths_ref) = fetch::zjpeg_list();

     @dbids = @$dbids_ref;
     @localpaths = @$localpaths_ref;
     log::main("Fetched " . scalar(@localpaths) . " zjpeg from database");
     log::zjpeg("<<  Starting transfer process  >>");

     @remotepaths = @localpaths;  # clone

     while($localpaths[$i])
     {
         # lookup in table first
         chomp( $tmpf = `basename $remotepaths[$i]` );
         chomp( $_ = `dirname $remotepaths[$i]` );
         $tmpd = hash::lookup($_);
         if ( $tmpd ne '' )
         {
             $remotepaths[$i] =  $tmpd. "/". $tmpf;
         }
         else
         {
             # hardcoded
             $remotepaths[$i] =~ s/\/mnt\/maket/\/mnt\/rmt_maket/;
         }

         if(-e $remotepaths[$i])
         {
             log::error("Remote file $remotefile[$i] already exists");
             db::change_status($dbids[$i], 1);
         }
         else
         {
             if( -e $localpaths[$i] )
             {
                 fileops::checkdir($remotepaths[$i]);
                 # set $size_orig
                 $size_orig = -s "$localpaths[$i]";

                 log::zjpeg("transferring $localpaths[$i] -> $remotepaths[$i]");
                 if( system("cp '$localpaths[$i]' '$remotepaths[$i]'") == 0 )
                 {
                         log::zjpeg("saved $localpaths[$i] -> $remotepaths[$i] [size_orig=$size_orig]");
                         # update database
                         db::change_status($dbids[$i], 1);
                         db::write_size_orig($dbids[$i], $size_orig);


                         $okay++;

                 }
                 else
                 {
                     # error in the copy process
                     log::zjpeg("error in copy process (see error log)");
                     log::error("error in copy process: $?");
                 }
             }
             else
             {
                 # error, local file doesn't exists
                 log::error("Can not open local file $localpaths[$i]");
                 log::zjpeg("Can not open local file $localpaths[$i]");
             }
         }

         # next iteration of 'while' and increment of $i
         $i++;
     }

     log::main("Saved $okay zjpeg on remote host");
     log::zjpeg("<<  End transfer process  >>");
 }

sub pjpeg()
 {
     my @dbids;
     my @localpaths;
     my @remotepaths;
     my $dbids_ref;
     my $localpaths_ref;
     my $i = 0;
     my $okay = 0;

     my $size_orig;

     ($dbids_ref, $localpaths_ref) = fetch::pjpeg_list();

     @dbids = @$dbids_ref;
     @localpaths = @$localpaths_ref;
     log::main("Fetched " . scalar(@localpaths) . " pjpeg from database");
     log::pjpeg("<<  Starting transfer process  >>");

     @remotepaths = @localpaths;  # clone

     while($localpaths[$i])
     {
         # lookup in table first
         chomp( $tmpf = `basename $remotepaths[$i]` );
         chomp( $_ = `dirname $remotepaths[$i]` );
         $tmpd = hash::lookup($_);
         if ( $tmpd ne '' )
         {
             $remotepaths[$i] =  $tmpd. "/". $tmpf;
         }
         else
         {
             # hardcoded
             $remotepaths[$i] =~ s/\/mnt\/maket/\/mnt\/rmt_maket/;
         }

         if(-e $remotepaths[$i])
         {
             log::error("Remote file $remotefile[$i] already exists");
             db::change_status($dbids[$i], 1);
         }
         else
         {
             if( -e $localpaths[$i] )
             {
                 fileops::checkdir($remotepaths[$i]);
                 # set $size_orig
                 $size_orig = -s "$localpaths[$i]";

                 log::pjpeg("transferring $localpaths[$i] -> $remotepaths[$i]");
                 if( system("cp '$localpaths[$i]' '$remotepaths[$i]'") == 0 )
                 {
                         log::pjpeg("saved $localpaths[$i] -> $remotepaths[$i] [size_orig=$size_orig]");
                         # update database
                         db::change_status($dbids[$i], 1);
                         db::write_size_orig($dbids[$i], $size_orig);


                         $okay++;

                 }
                 else
                 {
                     # error in the copy process
                     log::pjpeg("error in copy process (see error log)");
                     log::error("error in copy process: $?");
                 }
             }
             else
             {
                 # error, local file doesn't exists
                 log::error("Can not open local file $localpaths[$i]");
                 log::pjpeg("Can not open local file $localpaths[$i]");
             }
         }

         # next iteration of 'while' and increment of $i
         $i++;
     }

     log::main("Saved $okay pjpeg on remote host");
     log::pjpeg("<<  End transfer process  >>");
 }

return(1);
