#!/usr/bin/perl
# $Id: main.pl,v 1.7 2012/04/01 06:52:10 yason Exp $
use db;
use send;
use fileops;
use network;
use log;  # we need to critical log if remote host is down
use hash;

our $ZFILESERVER_IP = '192.168.16.1';
our @ZMPOINTS	    = ('/mnt/rmt_maket');
our $mpoint;

# according to manual of Perl's function system(),
# it is safer to autoflushing all out file disciptors
# cause of main process attempts to forcebly flush ones
# before any functions that may fork()
$| = 1;

fileops::check_lock();
fileops::take_lock();
fileops::cleanup();


#if( ! network::alive( $ZFILESERVER_IP ) )
#{
#    log::critical("$ZFILESERVER_IP is not reached by ICMP, considering host is down, EXITING");
#    # NOTREACHED
#}

# it seems like remote host is up and running ;)
#log::stdout("$ZFILESERVER_IP is alive, this is good.");


# Check mount table for remote mounts
foreach $mpoint (@ZMPOINTS)
{
    if ( ! `/bin/mount | /bin/grep $mpoint`)
    {
		log::critical("$mpoint not mounted. I can't run without that one! EXITING");
		# NOTREACHED
    }
}
log::stdout("Remote filesystems are mounted. All checks passed.");


# load directory map and print some debug
$_ = hash::loadtable();
if ( $_ == -1)
{
    # error opening file
    
    log::stdout("Error opening $hash::HASHFILE (maps will not be used)");
}
else
{
    log::stdout("Using directory map file $hash::HASHFILE ($_ records)");
}


# XXX maybe not to keep connection while rar & copy ?
db::connect();

send::zayavki();
send::probas();
send::tt();
send::zjpeg();
send::pjpeg();

db::disconnect();

fileops::release_lock();

#EOF
