#!/usr/bin/perl
# $Id: log.pm,v 1.6 2012/04/01 06:52:10 yason Exp $
package log;

my $DEBUG = 1;

my $MAIN_LOG = "/var/log/wpscripts/ztransfer/main.log";
my $ERROR_LOG = "/var/log/wpscripts/ztransfer/error.log";
my $ZAYAVKI_LOG = "/var/log/wpscripts/ztransfer/zayavki.log";
my $ZJPEGS_LOG = "/var/log/wpscripts/ztransfer/z_jpegs.log";
my $PJPEGS_LOG = "/var/log/wpscripts/ztransfer/p_jpegs.log";
my $PROBAS_LOG = "/var/log/wpscripts/ztransfer/probas.log";
my $TT_LOG = "/var/log/wpscripts/ztransfer/tt.log";
my $CRITICAL_LOG = "/var/log/wpscripts/ztransfer/critical.log";
my $FILE_LIST = "/var/log/wpscripts/ztransfer/FILES";
my $DIFFS_FILE = "/var/log/wpscripts/ztransfer/size_diffs.log";
my $CURRENT_FILE = "/var/log/wpscripts/ztransfer/FILE";
my $CURRENT_ACTION = "/var/log/wpscripts/ztransfer/ACTION";


# functions
sub error($)
{
    open(FILE, ">>$ERROR_LOG") or return();
    $_ = shift();
    print FILE scalar( localtime() ) . "| $_\n";
    print STDOUT scalar( localtime() ) . "| $_\n" if($DEBUG);
    close(FILE);
}


sub main($)
{
    open(FILE, ">>$MAIN_LOG") or return();
    $_ = shift();
    print FILE scalar( localtime() ) . "| $_\n";
    print STDOUT scalar( localtime() ) . "| $_\n" if($DEBUG);
    close(FILE);
}


sub zayavki($)
{
    open(FILE, ">>$ZAYAVKI_LOG") or return();
    $_ = shift();
    print FILE scalar( localtime() ) . "| $_\n";
    print STDOUT scalar( localtime() ) . "| $_\n" if($DEBUG);
    close(FILE);
}


sub probas($)
{
    open(FILE, ">>$PROBAS_LOG") or return();
    $_ = shift();
    print FILE scalar( localtime() ) . "| $_\n";
    print STDOUT scalar( localtime() ) . "| $_\n" if($DEBUG);
    close(FILE);
}

sub tt($)
{
    open(FILE, ">>$TT_LOG") or return();
    $_ = shift();
    print FILE scalar( localtime() ) . "| $_\n";
    print STDOUT scalar( localtime() ) . "| $_\n" if($DEBUG);
    close(FILE);
}

 sub zjpeg($) 	 
 { 	 
     open(FILE, ">>$ZJPEGS_LOG") or return(); 	 
     $_ = shift(); 	 
     print FILE scalar( localtime() ) . "| $_\n"; 	 
     print STDOUT scalar( localtime() ) . "| $_\n" if($DEBUG); 	 
     close(FILE); 	 
 }

 sub pjpeg($)
 {     
     open(FILE, ">>$PJPEGS_LOG") or return();
     $_ = shift();
     print FILE scalar( localtime() ) . "| $_\n";
     print STDOUT scalar( localtime() ) . "| $_\n" if($DEBUG);
     close(FILE);
 }

sub critical($)
{
    if( open(FILE, ">>$CRITICAL_LOG") )
    {
	$_ = shift();
	print FILE scalar( localtime() ) . "| $_\n";
	close(FILE);
	print STDOUT scalar( localtime() ) . "| $_\n" if($DEBUG);
    }
    exit(-1);	# exit program with -1 on *critical* error
}


sub filelist($)
{
    my $files_ref = shift;
    my @files = @$files_ref;
    
    open(FILE, ">$FILE_LIST") or return();
    foreach  $_ (@files)
    {
	print FILE "$_\n";
    }
    close(FILE);
}


sub diff($$$)
{
    my $path = shift;
    my $size_orig = shift;
    my $size_arc = shift;
    my $diff = $size_orig / $size_arc;

    # in human-readable format
    # we don't suppose gigabyte archives
    $size_orig = ($size_orig > 1048576 ? int($size_orig / 1024 / 1024) . " MB" : int($size_orig / 1024) . " KB");
    $size_arc = ($size_arc > 1048576 ? int($size_arc / 1024 / 1024) . " MB" : int($size_arc / 1024) . " KB");

    open(FILE, ">>$DIFFS_FILE") or return();
    print FILE scalar( localtime() ) . "| $path - original=$size_orig, compressed=$size_arc [diff=$diff]\n";
    print STDOUT scalar( localtime() ) . "| $path - original=$size_orig, compressed=$size_arc [diff=$diff]\n" if($DEBUG);
    close(FILE);

}


sub file_work_on($$)
{
    my $file = shift;
    my $action = shift;
    
    open(FILE, ">$CURRENT_FILE") or return();
	print FILE $file;
    close(FILE);
    
    open(ACT, ">$CURRENT_ACTION") or return();
	print ACT $action;
    close(ACT);

}


sub file_work_done()
{
    # consider this stuff okay, as usually ;-)
    #  but in future maybe not to call anything external?
    system("/bin/rm $CURRENT_FILE") if(-e $CURRENT_FILE);
    system("/bin/rm $CURRENT_ACTION") if(-e $CURRENT_ACTION);
}


sub stdout($)
{
    my $message = shift;
    print "STDOUT: $message\n";
}


return(1);
