#!/usr/bin/perl
# $Id: hash.pm,v 1.2 2011/06/03 11:03:41 yason Exp $
package hash;
use log;
use warnings;
use strict;

our $HASHFILE = "/var/run/ztransfer.hash";
our %directoryhash = ();

sub loadtable()
{
    # read table from $HASHFILE (if any) into %directoryhash
    # return number of records or return -1 on error
    my @lines;
    my @keys; #XXX
    my $line;
    my $lineno;	# for debug
    my $key;
    my $value;
    my $records = 0;
    
    open(FILE, "<$HASHFILE") or return (-1);
    
    @lines = <FILE>;
    foreach $line (@lines)
    {
	$lineno++;
	
        # treat '#' ANYWHERE as invalid character leading to ignore whole line
	# so it may be used as a comment
	if ( ((index($line, '#', 0)) == -1) and $line ne "\n")
	{
	    ($key, $value) = split(/\t+|\s+/, $line);
	    # avoid null elements
	    if ($value eq '')
	    {
		return(0);
	    }
	    
	    # don't count "\n"s
	    $records++;
	    $directoryhash{$key} = $value;
	}
    }
    close(FILE);
    
    return ($records);
}


sub lookup($)
{
    my $what = shift;

    if ( defined($directoryhash{$what}) )
    {
	# return value for further substitution
	return( $directoryhash{$what} );
	# NOTREACHED
    }
    # else
    return "";
}

return(1);
