#!/usr/bin/perl
#
# Contains directory operations (walkthrough etc.)
#

package dirops;

our $SPOOL = "/usr/backup/spool_zayavki";
our $IMAGE = "/usr/backup/images/zayavki";
our $SIZE_MIN = 4294967296;	# 4.00 GB (stands for 4.00 * 1024 ^ 3)
our $SIZE_MAX = 4563402752;	# 4.25 GB (stands for 4.25 * 1024 ^ 3)

our @allfiles;	# static array to keep files
our $offset = 0;
our $f_sizeof;
our $a_sizeof = 0;
our $a_count = 0;
our @a;

sub
walkthrough()
{
#    chdir($SPOOL);
    my @dirents = `ls -m $SPOOL`;
    my @str;
    
    for(my $i = 0; $i< scalar(@dirents); $i++)
    {
	chomp($dirents[$i]);
	
	@str =  split(', ', $dirents[$i]);
	
	push @allfiles, @str;
    
    }
    
}


sub
getnextblk()
{
    $a_sizeof = 0;
    @a = ();
    
    return( () ) if($offset == scalar(@allfiles));

    for(my $i = $offset; $i < scalar(@allfiles); $i++ )
    {
	    $f_sizeof = -s "$SPOOL/$allfiles[$i]";
	    # check sizes
	    if( $f_sizeof <= $SIZE_MAX - $a_sizeof)
	    {
		$a_sizeof += $f_sizeof;
		$a_count++;

		push @a, "$SPOOL/$allfiles[$i]";
	    }
	    else
	    {
		# $SIZE_MAX exceeded
		#
		# really don't assume BIG files
		#
		$offset = $i;
		
		return(@a);
	    }
    }

    if($a_sizeof < $SIZE_MIN )
    {
	return( ( ) );
	#NOTREACHED
    }
    
    return(@a);
}


return(1);
