#!/usr/bin/perl

use dirops;

our @image;
our $label;
our $ret;

dirops::walkthrough();

while(@image = dirops::getnextblk())
{
	# for each returned block

	$label = (split(/\//, $image[0]))[4];
	$label = $label . '-' . (split(/\//, $image[-1]))[4];
	
	print "Creating directory $dirops::IMAGE/$label.. ";
	if(!mkdir("$dirops::IMAGE/$label"))
	{
	    print "failed [$!]\n";
	    next;
	    # NOTREACHED
	}
	print "done\n";
	
	# open file in just crated directory
	# XXX need to be more verbose here
	open(INDEX, ">>$dirops::IMAGE/$label/INDEX") or next;
	print INDEX scalar(localtime()) . "\n";
	
	# move files there
	for(my $i = 0; $i < scalar(@image); $i++)
	{
	    print "moving $image[$i] to $dirops::IMAGE/$label .. ";
	    $ret = system("/bin/mv $image[$i] $dirops::IMAGE/$label");
	    
	    if($ret != 0)
	    {
		# mv returns error
		print "failed\n";
		
		# XXX should be more good here
		# maybe not to die ?
		die("cannot move $image[$i] to $dirops::IMAGE/$label! $!");
	    
	    }
	    # okay
	    print "done\n";
	    
	    # update INDEX
	    print INDEX "$image[$i]\n";
	}
	
	close(INDEX);
	
	# make ISO 9660 filesystem image
	$ret = system("/usr/local/bin/mkisofs -o $dirops::IMAGE/$label.iso $dirops::IMAGE/$label");
	if($ret != 0)
	{
	    # error 
	    print "error in making of isofs!\n";
	}
	else
	{
	    # image ready
	    # XXX cleanup
	    print "system(\"/bin/rm -r $dirops::IMAGE/$label\")\n";
	}
}
