#!/bin/sh



case ${1} in
-w)
	# wideprint, list
	case ${2} in
	    maket)
		echo "Listing old zayavki on maket"
		/usr/bin/find /mnt/maket/zayavki -type f -ctime +14d -exec ls -lh {} \;
		;;
	    *)
		echo "Usage: $0 <-w[r] | -e[r]> maket"
		echo "Be careful with -wr and -er keys. 'r' stands for \"remove\" here"
	esac
	;;

	# wideprint list all

-W)
    # wideprint, list
        echo "Listing old zayavki"
        /usr/bin/find /mnt/maket/zayavki -type f -ctime +14d -exec ls -lh {} \;
	;;
-wr)
	# wideprint, remove
	case ${2} in
	    maket)
		echo "Removing old zayavki on maket"
		/usr/bin/find /mnt/maket/zayavki -type f \! -name "*.rar" -ctime +14d -print -exec rm {} \;
		;;
	    *)
		echo "Usage: $0 <-w[r] | -e[r]> maket"
		echo "Be careful with -wr and -er keys. 'r' stands for \"remove\" here"
	esac
	;;

#-Wr)
#	# wideprint, remove ALL
#		echo "Removing old zayavki on V*"
#		/usr/bin/find /V[1-5]/zayavki -type f \! -name "*.rar" -ctime +14d -print -exec rm {} \;
#	;;
#-WR)
#    # wideprint, remove ALL
#        echo "Removing old zayavki on V*"
#        /usr/bin/find /V[1-5]/*/zayavki -type f -ctime +14d -print -exec rm {} \;
#    ;;

#
# EPD
-e)
	# epd, list
	case ${2} in
	    maket)
		echo "Listing old EPD zayavki on maket"
		/usr/bin/find /mnt/maket/*/epd_zayavki -type f -ctime +14d -exec ls -lh {} \;
		;;
	    *)
		echo "Usage: $0 <-w[r] | -e[r]> maket"
		echo "Be careful with -wr and -er keys. 'r' stands for \"remove\" here"
	esac
	;;
-er)
	# warn user
	echo "*  Please stop now and think twice.  *"

	echo "Have you backed up all those EPD files before deleting them? epickup(1) can do it for you."
	echo "Hit <Ctrl-C> to cancel or <Enter> to continue removing EPD files."
	read A

	# epd, remove
	case ${2} in
	    maket)
		echo "Removing old EPD zayavki on maket"
		/usr/bin/find /mnt/maket/*/epd_zayavki -type f \! -name "*.rar" -ctime +14d -print -exec rm {} \;
		;;
	    *)
		echo "Usage: $0 <-w[r] | -e[r]> maket"
		echo "Be careful with -wr and -er keys. 'r' stands for \"remove\" here"
	esac
	;;

*)
	echo "Usage: $0 <-w[r] | -e[r]> maket"
	echo "Be careful with -wr and -er keys. 'r' stands for \"remove\" here"

esac

