package index;

use strict;

# where to search for .index files
our @BVOLUMES = ("/B1", "/B2", "/usr/backup", "");	# terminate search with ""

# wideprint related index files
our $WPZ_INDEX = "wp_zayavki.index";
our $WPP_INDEX = "wp_proba.index";

# epd related index files
our $EPDZ_INDEX= "epd_zayavki.index";
our $EPDP_INDEX= "epd_proba.index";

# wideprint related directories
our $WPZ_DIR = "wp/zayavki";
our $WPP_DIR = "wp/proba";

# epd related directories
our $EPDZ_DIR= "epd/zayavki";
our $EPDP_DIR= "epd/proba";


sub lookup($$)
{
	my $file_type = shift;
	my $file_name = shift;
	my $bvolume;
	my @indexfile;
	my $bfilename;
	my $bfilepath;

	# lookup file in backups using .index files
	
	foreach $bvolume (@BVOLUMES) {
		# stop if "" encountered
		if ($bvolume eq "") {
			print "[index::lookup] $file_name not found on @BVOLUMES\n";

			return("");
		}

		if ($file_type eq "wpz") {
			# see if we can read index file
			if (! -r "$bvolume/$WPZ_INDEX") {
				die("index::lookup() can't open $bvolume/$WPZ_INDEX");
			}

			$bfilename = `grep ^$file_name $bvolume/$WPZ_INDEX`;
			chomp($bfilename);

			if ($bfilename ne "" ) {
				# file_name has been found in index on this bvolume 
				
				$bfilepath = "$bvolume/$WPZ_DIR/$bfilename";

				# check for file existence
				if (-e $bfilepath) {
					# file exists
					print "[index::lookup] found $bfilepath\n";

					return($bfilepath);
					# NOTREACHED
				} # else, file listed in index but we can't stat it
				print "[index::lookup] $bfilename listed in $bvolume/$WPZ_INDEX but it doesn't exist\n";
				# will look in next bvolume
				# next

			} # else, file hasn't been found in index on that bvolume
			# proceed to next bvolume, if any
			next;
		} # ! "wpz"

		if ($file_type eq "wpp") {
			# see if we can read index file
			if (! -r "$bvolume/$WPP_INDEX") {
				die("index::lookup() can't open $bvolume/$WPP_INDEX");
			}

			$bfilename = `grep ^$file_name $bvolume/$WPP_INDEX`;
			chomp($bfilename);

			if ($bfilename ne "" ) {
				# file_name has been found in index on this bvolume 
				
				$bfilepath = "$bvolume/$WPP_DIR/$bfilename";

				# check for file existence
				if (-e $bfilepath) {
					# file exists
					print "[index::lookup] found $bfilepath\n";

					return($bfilepath);
					# NOTREACHED
				} # else, file listed in index but we can't stat it
				print "[index::lookup] $bfilename listed in $bvolume/$WPP_INDEX but it doesn't exist\n";
				# will look in next bvolume
				# next

			} # else, file hasn't been found in index on that bvolume
			# proceed to next bvolume, if any
			next;
		} # ! "wpp"

		if ($file_type eq "epdz") {
			# see if we can read index file
			if (! -r "$bvolume/$EPDZ_INDEX") {
				die("index::lookup() can't open $bvolume/$EPDZ_INDEX");
			}

			$bfilename = `grep ^$file_name $bvolume/$EPDZ_INDEX`;
			chomp($bfilename);

			if ($bfilename ne "" ) {
				# file_name has been found in index on this bvolume 
				
				$bfilepath = "$bvolume/$EPDZ_DIR/$bfilename";

				# check for file existence
				if (-e $bfilepath) {
					# file exists
					print "[index::lookup] found $bfilepath\n";

					return($bfilepath);
					# NOTREACHED
				} # else, file listed in index but we can't stat it
				print "[index::lookup] $bfilename listed in $bvolume/$EPDZ_INDEX but it doesn't exist\n";
				# will look in next bvolume
				# next

			} # else, file hasn't been found in index on that bvolume
			# proceed to next bvolume, if any
			next;
		} # ! "epdz"

		if ($file_type eq "epdp") {
			# see if we can read index file
			if (! -r "$bvolume/$EPDP_INDEX") {
				die("index::lookup() can't open $bvolume/$EPDP_INDEX");
			}

			$bfilename = `grep ^$file_name $bvolume/$EPDP_INDEX`;
			chomp($bfilename);

			if ($bfilename ne "" ) {
				# file_name has been found in index on this bvolume 
				
				$bfilepath = "$bvolume/$EPDP_DIR/$bfilename";

				# check for file existence
				if (-e $bfilepath) {
					# file exists
					print "[index::lookup] found $bfilepath\n";

					return($bfilepath);
					# NOTREACHED
				} # else, file listed in index but we can't stat it
				print "[index::lookup] $bfilename listed in $bvolume/$EPDP_INDEX but it doesn't exist\n";
				# will look in next bvolume
				# next

			} # else, file hasn't been found in index on that bvolume
			# proceed to next bvolume, if any
			next;
		} # ! "epdp"
		
	}

}

return 1;

