package fs;

use index;

# total returned files
our $NRETURNED = 0;

sub copy($$$$)
{
	my $ID_ref = shift;
	my $file_type_ref = shift;
	my $file_name_ref = shift;
	my $file_retpath_ref = shift;

	my @ID           = @$ID_ref;
	my @file_type    = @$file_type_ref;
	my @file_name    = @$file_name_ref;
	my @file_retpath = @$file_retpath_ref;

	my $i;
	my $bfilepath;
	my $bfilebasename;
	my $retval;

	my $oldsize;
	my $newsize;

	print "[fs::copy] entering with " . scalar(@file_type) . " ab_want files\n";

	# TODO

	# iterate over all given files
	for($i = 0; $i < scalar(@file_type); $i++) {
	
		$bfilepath = index::lookup($file_type[$i], $file_name[$i]);

		if ($bfilepath eq "") {
			# requested file not found in backups
			# XXX notify via email ?
			print "[fs::copy] $file_name[$i] of type $file_type[$i] not found in backups\n";

			# XXX unwant file in db, maybe unneccessary?
			dbops::unwant($file_type[$i], $ID[$i]);

			next;
			# NOTREACHED
		}

		# here it is safe to do basename
		$bfilebasename = `basename $bfilepath`;
		chomp($bfilebasename);

		print "[fs::copy] initiating copy $bfilepath to $file_retpath[$i]/$bfilebasename\n";

		# execute system command
		system("cp $bfilepath $file_retpath[$i]");

		if ($? != 0) {
			# cp failed
			print "[fs::copy] copy failed (retval=$?)\n";

			# process next element
			next;
		}

		# check sizes
		if (-s $bfilepath == -s "$file_retpath[$i]/$bfilebasename") {

			print "[fs::copy] copy completed, sizes matched\n";

			$NRETURNED++;

			# update database
			print "file_type=$file_type[$i] ID=$ID[$i]\n";
			dbops::unwant($file_type[$i], $ID[$i]);

		}
		else {
			# sized did not matched

			print "[fs::copy] copy completed, but sizes DID NOT MATCHED\n";
			print "[fs::copy] will NOT update database\n";

		}

		# next file
		next;
	}


	print "[fs::copy] leaving (copied $NRETURNED files)\n";
}

return 1;

