#!/usr/bin/perl
use strict;
use dbops;
use fs;

# We will use array of files, each described as follows:
#  $ID[$file]           -- ID in database
#  $file_type[$file]    -- string constant that describes type of file (e.g "epdz")
#  $file_name[$file]    -- file name (e.g 66666.eps)
#  $file_retpath[$file] -- return path without leading slash (e.g /WIDEPRINT//)
our $ID_ref;
our $file_type_ref;
our $file_name_ref;
our $file_retpath_ref;

# will deref ID_ref to know how many files we've got
our @ID;

dbops::connect() or die("dbops::connect()");
dbops::select()  or die("dbops::select()");

($ID_ref, $file_type_ref, $file_name_ref, $file_retpath_ref) = dbops::getall();

# temporary
@ID = @$ID_ref;

if (scalar(@$file_name_ref) == 0) {

	print "[main] nothing to do\n";

	dbops::disconnect();
	exit(-1);
}

# got something
print "[main] got " . scalar(@ID) . " ab_want files from all tables\n";

fs::copy($ID_ref, $file_type_ref, $file_name_ref, $file_retpath_ref);

dbops::disconnect();

exit(0);

