#!/usr/bin/perl

package log;

our $DEBUG = 1;

our $OPS_LOGFILE = "/var/log/epickup/epickup.log";
our $ERR_LOGFILE = "/var/log/epickup/errors.log";

sub stdout($)
{
    my $mesg = shift;

    print scalar(localtime()) . "| $mesg";
}

sub put($)
{
    my $mesg = shift;


    open(FILE, ">>$OPS_LOGFILE") or return();

    print FILE scalar( localtime() ) . "| $mesg\n";
    close(FILE);

    print STDOUT scalar( localtime() ) . "| $mesg\n" if($DEBUG);
}
return(1);


sub err($)
{
    my $mesg = shift;


    open(FILE, ">>$ERR_LOGFILE") or return();

    print FILE scalar( localtime() ) . "| $mesg\n";
    close(FILE);

    print STDOUT scalar( localtime() ) . "| $mesg\n" if($DEBUG);
}
return(1);
