#!/usr/bin/perl

# Back up EPD files. Steps are:
# - grep printed and not backed up EPD files from db.
# - iterate over result; rar file using tmp/ dir in spool.
# - put archive into spool.
# - goto step 2 if there are more files.


use dbops;
use conv;
use strict;
use log;

# SIGINT catcher
$SIG{INT} = \&sigint;
sub sigint()
{
    log::stdout("caught interrupt signal (exiting).\n");
    exit(1);
}

our $SPOOL_EPDZ_DIR = "/usr/backup/epd/zayavki";
our $SPOOL_EPDP_DIR = "/usr/backup/epd/proba";
our @ID;
our $ID_ref;
our @paths;
our $paths_ref;
our $i;

dbops::connect();
dbops::select();

# EPD zayavki
($ID_ref, $paths_ref) = dbops::fetch($dbops::EPD_ZAYAVKA_T);
@ID 		= @$ID_ref;
@paths          = @$paths_ref;


log::stdout("[working on epd-zayavki] ($#ID elements)\n");
for ($i = 0; $i < $#paths; $i++)
{
    # db::fetch() gives us converted pathnames
    if (! -e $paths[$i])
    {
	log::err("$paths[$i] doesn't exist");
	log::put("item with ID=$ID[$i] is broken (not found). FIXING");
	
	# XXX here we mark file as backed up even it doesn't exist.
	dbops::fixate($ID[$i]);
	next;
	# NOTREACHED
    }
    
    log::stdout("compressing $paths[$i] into spool..\n");
    
    system("/usr/local/bin/rar a -rr10% -ep '$SPOOL_EPDZ_DIR/".conv::basename($paths[$i]).".rar'"." \"$paths[$i]\"");
    if( ($? >> 8) == 0)
    {
	# 0 exit status
	log::stdout(" $paths[$i] compressed\n");
	log::put("created archive $paths[$i].rar");

	# XXX additional check, maybe unneeded?
	if (-e "$SPOOL_EPDZ_DIR/".conv::basename($paths[$i]).".rar")
	{
	    # modify DB
	    dbops::markok($ID[$i]);
	    log::put("ID=$ID[$i] marked as backed up");
	}
	else
	{
	    # something strange
	    # do not modify db
	    log::err("$SPOOL_EPDZ_DIR/".conv::basename($paths[$i]).".rar can't stat after compressing");
	}
    }
    else
    {
	# error
	log::stdout(" $paths[$i] compression failed!\n");
    }
    

} # epd-zayavki

# probas
($ID_ref, $paths_ref) = dbops::fetch($dbops::EPD_PROBA_T);
@ID 		= @$ID_ref;
@paths          = @$paths_ref;

log::stdout("[working on epd-probas] ($#ID elements)\n");
for ($i = 0; $i < $#paths; $i++)
{
    # db::fetch() gives us converted pathnames
    if (! -e $paths[$i])
    {
	log::err("$paths[$i] doesn't exist");
	log::put("item with ID=$ID[$i] is broken (not found). FIXING");
	
	# XXX here we mark file as backed up even it doesn't exist.
	dbops::fixate($ID[$i]);
	next;
	# NOTREACHED
    }
    
    log::stdout("compressing $paths[$i] into spool..\n");
    
    system("/usr/local/bin/rar a -rr10% -ep $SPOOL_EPDP_DIR/".conv::basename($paths[$i]).".rar"." $paths[$i]");
    if( ($? >> 8) == 0)
    {
	# 0 exit status
	log::stdout(" $paths[$i] compressed\n");
	log::put("created archive $paths[$i].rar");

	# XXX additional check, maybe unneeded?
	if (-e "$SPOOL_EPDP_DIR/".conv::basename($paths[$i]).".rar")
	{
	    # modify DB
	    dbops::markok($ID[$i]);
	    log::put("ID=$ID[$i] marked as backed up");
	}
	else
	{
	    # something strange
	    # do not modify db
	    log::err("$SPOOL_EPDP_DIR/".conv::basename($paths[$i]).".rar can't stat after compressing");
	}
    }
    else
    {
	# error
	log::stdout(" $paths[$i] compression failed!\n");
    }
    

} # epd-probas


dbops::disconnect();
